' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Partial Class ShopDefault
  Inherits System.Web.UI.Page

  Private currentPage As Integer = -1
  Dim categoryId As Integer = 1


  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    If Request.QueryString("Cat") IsNot Nothing Then
      Try
        categoryId = Convert.ToInt32(Request.QueryString.Get("Cat"))
      Catch ex As Exception
        Throw
      End Try
    End If

    currentPage = Convert.ToInt32(Request.QueryString.Get("page"))
    lnkPreviousPage.NavigateUrl = String.Format("?Page={0}&Cat={1}", (currentPage - 1), categoryId)
    lnkNextPage.NavigateUrl = String.Format("?Page={0}&Cat={1}", (currentPage + 1), categoryId)
    If Not Page.IsPostBack Then
      LoadData()
    End If
  End Sub

  Private Sub LoadData()
    Dim myPageDataSource As New PagedDataSource()

    myPageDataSource.DataSource = ShopManager.GetProductList(categoryId)
    myPageDataSource.AllowPaging = True
    myPageDataSource.PageSize = 4

    Try

      If myPageDataSource.PageCount - 1 < currentPage Then
        currentPage = myPageDataSource.PageCount - 1
      End If

      If (currentPage < 0) Then
        currentPage = 0
      End If

      myPageDataSource.CurrentPageIndex = currentPage
    Catch

      myPageDataSource.CurrentPageIndex = 0

    End Try

    ' Wcz i/lub wyacz odnoniki do poprzedniej i nastpnej strony
    lnkPreviousPage.Visible = Not myPageDataSource.IsFirstPage
    lnkNextPage.Visible = Not myPageDataSource.IsLastPage

    DataList1.DataSource = myPageDataSource
    DataList1.DataBind()

  End Sub

  Public Function GetDescription(ByVal theDescription As Object) As String
    Dim tempString As String = theDescription.ToString()
    If tempString.Length > 50 Then
      tempString = tempString.Substring(0, 47) & "..."
    End If
    Return tempString
  End Function

  Protected Sub Repeater1_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.RepeaterItemEventArgs) Handles Repeater1.ItemDataBound
    Select Case e.Item.ItemType
      Case ListItemType.Item, ListItemType.AlternatingItem
        Dim theRow As DataRowView = CType(e.Item.DataItem, DataRowView)
        Dim currentCategoryId As Integer = Convert.ToInt32(theRow("Id"))
        If categoryId = currentCategoryId Then
          Dim myLink As HyperLink = CType(e.Item.Controls(1), HyperLink)
          myLink.CssClass = "SelectedCategory"
        End If
    End Select
  End Sub
End Class
